/*
 * Decompiled with CFR 0.152.
 */
package de.kilobyte22.config;

import de.kilobyte22.config.ConfigOption;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ConfigElement {
    private List<ConfigOption> options = new LinkedList<ConfigOption>();
    private Map<String, List<ConfigOption>> optionsByKey = new HashMap<String, List<ConfigOption>>();

    public void add(ConfigOption option) {
        this.options.add(option);
        if (!this.optionsByKey.containsKey(option.getName())) {
            this.optionsByKey.put(option.getName(), new LinkedList());
        }
        this.optionsByKey.get(option.getName()).add(option);
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        for (ConfigOption option : this.options) {
            sb.append(option.toString(indent));
        }
        return sb.toString();
    }

    public List<ConfigOption> getOptions() {
        return this.options;
    }

    public List<ConfigOption> getOptions(String name) {
        if (this.optionsByKey.containsKey(name)) {
            return this.optionsByKey.get(name);
        }
        return new LinkedList<ConfigOption>();
    }

    public boolean has(String name) {
        return this.optionsByKey.containsKey(name) && this.optionsByKey.get(name).size() > 0;
    }

    public ConfigOption first(String name) {
        return this.optionsByKey.get(name).get(0);
    }
}

