/*
 * Decompiled with CFR 0.152.
 */
package de.kilobyte22.config;

import de.kilobyte22.config.ConfigElement;
import de.kilobyte22.config.ConfigOption;
import de.kilobyte22.config.Parser;
import de.kilobyte22.config.Tokenizer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Scanner;

public class ConfigFile
extends ConfigElement {
    private final File file;
    private ConfigElement root;

    public ConfigFile(String name) {
        this(new File(name));
    }

    public ConfigFile(File file) {
        this.file = file;
    }

    public void load() {
        try {
            Scanner s = new Scanner(new FileInputStream(this.file));
            s.useDelimiter("\\Z");
            String code = s.next();
            this.root = new Parser(new Tokenizer(code).run()).parse();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<ConfigOption> getOptions() {
        return this.root.getOptions();
    }

    @Override
    public List<ConfigOption> getOptions(String name) {
        return this.root.getOptions(name);
    }

    @Override
    public boolean has(String name) {
        return this.root.has(name);
    }

    @Override
    public ConfigOption first(String name) {
        return this.root.first(name);
    }
}

