/*
 * Decompiled with CFR 0.152.
 */
package de.kilobyte22.config;

import de.kilobyte22.config.ConfigElement;
import de.kilobyte22.config.ConfigValue;
import de.kilobyte22.config.LongValue;
import de.kilobyte22.config.StringValue;
import java.util.LinkedList;
import java.util.List;

public class ConfigOption {
    private final String name;
    private ConfigElement sub;
    private List<ConfigValue> args = new LinkedList<ConfigValue>();

    public ConfigOption(String name) {
        this.name = name;
    }

    public ConfigElement getSub() {
        return this.sub;
    }

    public void setSub(ConfigElement sub) {
        this.sub = sub;
    }

    public void addArg(ConfigValue configValue) {
        this.args.add(configValue);
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(indent).append("Name: ").append(this.name).append("\n");
        sb.append(indent).append("Args: ");
        for (ConfigValue arg : this.args) {
            sb.append(arg.toString()).append(", ");
        }
        sb.append("\n").append(indent).append("Sub: ");
        if (this.sub == null) {
            sb.append("<null>");
        } else {
            sb.append("\n").append(this.sub.toString(indent + "  "));
        }
        sb.append("\n\n");
        return sb.toString();
    }

    public int argCount() {
        return this.args.size();
    }

    public String getString(int idx) {
        return ((StringValue)this.args.get(idx)).getValue();
    }

    public int getInt(int idx) {
        return ((LongValue)this.args.get(idx)).toInt();
    }

    public String getName() {
        return this.name;
    }
}

