/*
 * Decompiled with CFR 0.152.
 */
package de.kilobyte22.config;

import de.kilobyte22.config.ConfigElement;
import de.kilobyte22.config.ConfigOption;
import de.kilobyte22.config.ConfigValue;
import de.kilobyte22.config.DoubleValue;
import de.kilobyte22.config.LongValue;
import de.kilobyte22.config.ParserException;
import de.kilobyte22.config.StringValue;
import de.kilobyte22.config.Token;
import java.util.List;

public class Parser {
    private final List<Token> tokens;
    private int pos = 0;

    public Parser(List<Token> tokens) {
        this.tokens = tokens;
    }

    public ConfigElement parse() {
        return this.parseScope(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private ConfigElement parseScope(boolean isRoot) {
        ConfigElement el = new ConfigElement();
        block10: while (!isRoot || this.pos < this.tokens.size()) {
            Token t = this.next();
            if (t.isSyntaxElement()) {
                switch (t.getData().charAt(0)) {
                    case ';': {
                        continue block10;
                    }
                    case '{': {
                        throw new ParserException("unexpected { in line %s", t.getLine());
                    }
                    case '}': {
                        return el;
                    }
                }
            }
            ConfigOption option = new ConfigOption(t.getData());
            block11: while (true) {
                if ((t = this.next()).isSyntaxElement()) {
                    switch (t.getData().charAt(0)) {
                        case ';': {
                            break block11;
                        }
                        case '}': {
                            throw new ParserException("Unexpected '}' in line %s", t.getLine());
                        }
                        case '{': {
                            option.setSub(this.parseScope(false));
                            this.expect(";");
                            break block11;
                        }
                    }
                    continue;
                }
                option.addArg(this.makeArg(t));
            }
            el.add(option);
        }
        return el;
    }

    private ConfigValue makeArg(Token t) {
        String data = t.getData();
        if (t.isNumber()) {
            if (data.contains(".")) {
                double d = Double.parseDouble(data);
                return new DoubleValue(d);
            }
            long l = Long.parseLong(data);
            return new LongValue(l);
        }
        return new StringValue(data);
    }

    private Token expect(String s) {
        Token t = this.next();
        if (!t.getData().equals(s)) {
            throw new ParserException("Unexpected %s, expected %s in line %s", t.getData(), s, t.getLine());
        }
        return t;
    }

    private Token next() {
        if (this.pos == this.tokens.size()) {
            throw new ParserException("Unexpected EOF", new Object[0]);
        }
        return this.tokens.get(this.pos++);
    }

    private Token expectRegularToken() {
        Token t = this.next();
        if (!t.isRegularToken()) {
            throw new ParserException("Expected token, got %s in line %s", t.getData(), t.getLine());
        }
        return t;
    }
}

