/*
 * Decompiled with CFR 0.152.
 */
package de.kilobyte22.config;

import de.kilobyte22.config.Token;
import java.util.LinkedList;
import java.util.List;

public class Tokenizer {
    private final String input;
    private List<Token> ret;
    private String current;
    private ParseScope scope = ParseScope.NONE;
    private int pos = 0;
    private char last = '\u0000';
    private int commentLevel = 0;
    private int line = 1;
    private boolean hadR = false;

    private char next() {
        return this.input.charAt(this.pos++);
    }

    public Tokenizer(String input) {
        this.input = input;
    }

    public synchronized List<Token> run() {
        if (this.ret != null) {
            return this.ret;
        }
        this.ret = new LinkedList<Token>();
        while (this.pos < this.input.length()) {
            char c;
            block31: {
                block34: {
                    block33: {
                        block32: {
                            block30: {
                                c = this.next();
                                this.handleRN(c);
                                if (this.scope != ParseScope.STRING) break block30;
                                switch (c) {
                                    case '\"': {
                                        this.finishToken();
                                        break;
                                    }
                                    case '\\': {
                                        this.scope = ParseScope.ESCAPED_STRING;
                                        break;
                                    }
                                    default: {
                                        this.current = this.current + c;
                                        break;
                                    }
                                }
                                break block31;
                            }
                            if (this.scope != ParseScope.ESCAPED_STRING) break block32;
                            switch (c) {
                                case 'n': {
                                    this.current = this.current + "\n";
                                    break;
                                }
                                case 't': {
                                    this.current = this.current + "\t";
                                    break;
                                }
                                default: {
                                    this.current = this.current + c;
                                }
                            }
                            this.scope = ParseScope.STRING;
                            break block31;
                        }
                        if (this.scope != ParseScope.COMMENT) break block33;
                        switch (c) {
                            case '\n': 
                            case '\r': {
                                this.scope = ParseScope.NONE;
                                break;
                            }
                        }
                        break block31;
                    }
                    if (this.scope != ParseScope.MULTI_COMMENT) break block34;
                    switch (c) {
                        case '/': {
                            if (this.last == '*' && --this.commentLevel <= 0) {
                                assert (this.commentLevel == 0);
                                this.scope = ParseScope.NONE;
                                break;
                            }
                            break block31;
                        }
                        case '*': {
                            if (this.last == '/') {
                                ++this.commentLevel;
                                break;
                            }
                            break block31;
                        }
                    }
                    break block31;
                }
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        this.finishToken();
                        break;
                    }
                    case ';': 
                    case '{': 
                    case '}': {
                        this.finishToken();
                        this.scope = ParseScope.TOKEN;
                        this.current = "" + c;
                        this.finishToken();
                        break;
                    }
                    case '\"': {
                        this.finishToken();
                        this.current = "";
                        this.scope = ParseScope.STRING;
                        break;
                    }
                    case '#': {
                        this.scope = ParseScope.COMMENT;
                        break;
                    }
                    case '*': 
                    case '/': {
                        if (this.last == '/') {
                            if (c == '/') {
                                this.scope = ParseScope.COMMENT;
                                break;
                            }
                            this.scope = ParseScope.MULTI_COMMENT;
                            this.commentLevel = 1;
                            break;
                        }
                    }
                    default: {
                        if (this.scope == ParseScope.NONE) {
                            this.scope = ParseScope.TOKEN;
                            this.current = c + "";
                            break;
                        }
                        this.current = this.current + c;
                    }
                }
            }
            this.last = c;
        }
        return this.ret;
    }

    private void handleRN(char c) {
        switch (c) {
            case '\r': {
                this.hadR = true;
                ++this.line;
                break;
            }
            case '\n': {
                if (this.hadR) {
                    this.hadR = false;
                    break;
                }
                ++this.line;
                break;
            }
            default: {
                this.hadR = false;
            }
        }
    }

    private void finishToken() {
        if (this.scope == ParseScope.NONE) {
            return;
        }
        Token t = new Token(this.current);
        switch (this.scope) {
            case TOKEN: {
                if (this.current.length() == 1 && ";{}".contains(this.current)) {
                    t.setSyntaxElement(true);
                }
                try {
                    Double.parseDouble(this.current);
                    t.setNumber(true);
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case STRING: {
                t.setString(true);
            }
        }
        this.current = null;
        this.scope = ParseScope.NONE;
        t.setLine(this.line);
        this.ret.add(t);
    }

    private static enum ParseScope {
        NONE,
        TOKEN,
        ESCAPED_STRING,
        STRING,
        COMMENT,
        MULTI_COMMENT;

    }
}

