/*
 * Decompiled with CFR 0.152.
 */
package de.kilobyte22.optionparse;

import de.kilobyte22.optionparse.OptionParser;

public class Option {
    private final String name;
    private final OptionParser parser;
    private ArgumentType argumentType = ArgumentType.NONE;
    private boolean multiple = false;
    private String help = null;
    private String defaultValue = null;

    Option(String name, OptionParser parser) {
        this.name = name;
        this.parser = parser;
        parser.registerOption(name, this);
    }

    public Option alias(String ... names) {
        for (String name : names) {
            this.parser.registerOption(name, this);
        }
        return this;
    }

    public Option alias(char ... names) {
        for (char name : names) {
            this.parser.registerOption(name, this);
        }
        return this;
    }

    public Option withArgument() {
        this.argumentType = ArgumentType.NEEDED;
        return this;
    }

    public Option withOptionalArgument() {
        this.argumentType = ArgumentType.OPTIONAL;
        return this;
    }

    public Option multiple() {
        this.multiple = true;
        return this;
    }

    public Option help(String help) {
        this.help = help;
        return this;
    }

    public Option defaultValue(String value) {
        this.defaultValue = value;
        return this;
    }

    public boolean allowsMultiple() {
        return this.multiple;
    }

    public Object getArgumentType() {
        return this.argumentType;
    }

    public String getName() {
        return this.name;
    }

    public String getHelp() {
        return this.help;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    static enum ArgumentType {
        NONE,
        OPTIONAL,
        NEEDED;

    }
}

