/*
 * Decompiled with CFR 0.152.
 */
package de.kilobyte22.optionparse;

import de.kilobyte22.optionparse.Option;
import de.kilobyte22.optionparse.OptionParseException;
import de.kilobyte22.optionparse.OptionSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class OptionParser {
    private Map<String, Option> longOptions = new HashMap<String, Option>();
    private Map<Character, Option> shortOptions = new HashMap<Character, Option>();

    public Option addOption(String name) {
        return new Option(name, this);
    }

    public OptionSet parse(String[] args) {
        OptionSet ret = new OptionSet(this);
        boolean noparse = false;
        Option tmpoption = null;
        for (String arg : args) {
            if (noparse) {
                ret.addNonArg(arg);
                continue;
            }
            if (arg.startsWith("-")) {
                if (tmpoption != null) {
                    if (tmpoption.getArgumentType() == Option.ArgumentType.NEEDED) {
                        throw new OptionParseException("option --" + tmpoption.getName() + " needs an argument");
                    }
                    ret.addOption(tmpoption, tmpoption.getDefaultValue());
                    tmpoption = null;
                }
                if (arg.startsWith("--")) {
                    if (arg.equals("--")) {
                        noparse = true;
                        continue;
                    }
                    String name = arg.substring(2);
                    Option option = this.longOptions.get(name);
                    if (option == null) {
                        throw new OptionParseException("unknown option --" + name);
                    }
                    if (ret.isSet(option) && !option.allowsMultiple()) {
                        throw new OptionParseException("option --" + name + " may only be used once");
                    }
                    if (option.getArgumentType() != Option.ArgumentType.NONE) {
                        tmpoption = option;
                        continue;
                    }
                    ret.addOption(option, null);
                    continue;
                }
                if (arg.equals("-")) continue;
                String argdata = arg.substring(1);
                for (int i = 0; i < argdata.length(); ++i) {
                    char name;
                    Option option;
                    if (tmpoption != null) {
                        if (tmpoption.getArgumentType() == Option.ArgumentType.NEEDED) {
                            throw new OptionParseException("option --" + tmpoption.getName() + " needs an argument");
                        }
                        ret.addOption(tmpoption, tmpoption.getDefaultValue());
                        tmpoption = null;
                    }
                    if ((option = this.shortOptions.get(Character.valueOf(name = argdata.charAt(i)))) == null) {
                        throw new OptionParseException("unknown option -" + name);
                    }
                    if (ret.isSet(option) && !option.allowsMultiple()) {
                        throw new OptionParseException("option -" + name + " may only be used once");
                    }
                    if (option.getArgumentType() != Option.ArgumentType.NONE) {
                        tmpoption = option;
                        continue;
                    }
                    ret.addOption(option, null);
                }
                continue;
            }
            if (tmpoption != null) {
                ret.addOption(tmpoption, arg);
                tmpoption = null;
                continue;
            }
            ret.addNonArg(arg);
        }
        if (tmpoption != null) {
            if (tmpoption.getArgumentType() == Option.ArgumentType.NEEDED) {
                throw new OptionParseException("option --" + tmpoption.getName() + " needs an argument");
            }
            ret.addOption(tmpoption, tmpoption.getDefaultValue());
        }
        return ret;
    }

    void registerOption(String name, Option option) {
        this.longOptions.put(name, option);
    }

    void registerOption(char name, Option option) {
        this.shortOptions.put(Character.valueOf(name), option);
    }

    public static String[] splitArgs(String args) {
        ArrayList<String> ret = new ArrayList<String>();
        String current = "";
        SplitMode mode = SplitMode.SPACE;
        boolean escaped = false;
        boolean first = true;
        boolean forceSpace = false;
        block11: for (int i = 0; i < args.length(); ++i) {
            char c = args.charAt(i);
            if (forceSpace && c != ' ') {
                throw new OptionParseException("char " + i + ": space expected, got " + c);
            }
            if (escaped) {
                current = current + c;
                escaped = false;
                continue;
            }
            switch (c) {
                case '\\': {
                    escaped = true;
                    continue block11;
                }
                case '\"': {
                    if (first) {
                        first = false;
                        mode = SplitMode.SINGLE_QUOTE;
                        continue block11;
                    }
                    if (mode == SplitMode.SINGLE_QUOTE) {
                        mode = SplitMode.SPACE;
                        forceSpace = true;
                        continue block11;
                    }
                    current = current + '\"';
                    continue block11;
                }
                case '\'': {
                    if (first) {
                        first = false;
                        mode = SplitMode.SINGLE_QUOTE;
                        continue block11;
                    }
                    if (mode == SplitMode.SINGLE_QUOTE) {
                        mode = SplitMode.SPACE;
                        forceSpace = true;
                        continue block11;
                    }
                    current = current + "'";
                    continue block11;
                }
                case ' ': {
                    if (first) continue block11;
                    forceSpace = false;
                    if (mode == SplitMode.SPACE) {
                        ret.add(current);
                        current = "";
                        first = true;
                        continue block11;
                    }
                    current = current + " ";
                    continue block11;
                }
                default: {
                    first = false;
                    current = current + c;
                }
            }
        }
        switch (mode) {
            case SPACE: {
                if (current.length() <= 0) break;
                ret.add(current);
                break;
            }
            case SINGLE_QUOTE: {
                throw new OptionParseException("Unexpected EOL, single quote expected");
            }
            case DOUBLE_QUOTE: {
                throw new OptionParseException("Unexpected EOL, double quote expected");
            }
        }
        return ret.toArray(new String[0]);
    }

    private static enum SplitMode {
        SPACE,
        SINGLE_QUOTE,
        DOUBLE_QUOTE;

    }
}

