/*
 * Decompiled with CFR 0.152.
 */
package de.kilobyte22.optionparse;

import de.kilobyte22.optionparse.Option;
import de.kilobyte22.optionparse.OptionParser;
import de.kilobyte22.optionparse.OptionUsageException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class OptionSet {
    private final OptionParser parser;
    private final ArrayList<String> nonoption = new ArrayList();
    private final Map<Option, List<String>> data = new HashMap<Option, List<String>>();

    OptionSet(OptionParser parser) {
        this.parser = parser;
    }

    public void addNonArg(String arg) {
        this.nonoption.add(arg);
    }

    public boolean isSet(Option option) {
        return this.data.containsKey(option);
    }

    void addOption(Option tmpoption, String data) {
        List<String> values;
        if (this.data.containsKey(tmpoption)) {
            values = this.data.get(tmpoption);
        } else {
            values = new LinkedList<String>();
            this.data.put(tmpoption, values);
        }
        if (data != null) {
            values.add(data);
        }
    }

    public String getValueFor(Option option) {
        List<String> values = this.data.get(option);
        if (values == null) {
            throw new OptionUsageException("option --" + option.getName() + " was not set");
        }
        if (values.size() == 0) {
            return null;
        }
        return values.get(0);
    }

    public List<String> getValuesFor(Option option) {
        return this.data.get(option);
    }

    public boolean hasArgument(Option option) {
        List<String> values = this.data.get(option);
        if (values == null) {
            throw new OptionUsageException("option --" + option.getName() + " was not set");
        }
        return values.size() > 0;
    }

    public String getNonOptionArg(int index) {
        if (index >= this.nonoption.size()) {
            return null;
        }
        return this.nonoption.get(index);
    }

    public String[] getNonOptionArgs() {
        String[] ret = new String[this.nonoption.size()];
        for (int i = 0; i < this.nonoption.size(); ++i) {
            ret[i] = this.nonoption.get(i);
        }
        return ret;
    }

    public String getNonOptionArgOrError(int index) {
        if (index >= this.nonoption.size()) {
            throw new OptionUsageException("required argument #" + (index + 1) + " not given");
        }
        return this.nonoption.get(index);
    }
}

